/*
 * Agent.java
 *
 * 
 */
 package	DisCSP.DistributedCSP;

import java.io.*;
import java.net.*;
import DisCSP.CSPLexerParser.*;
import DisCSP.CSP.*;
import DisCSP.CSP.Constraint.*;
import DisCSP.Exception.*;
import DisCSP.DistributedCSP.ExternalConstraint.*;
import java.util.Vector;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class Agent extends Thread
{
	private AgentState state;
	private Neighbourhood nhood;
	private DisConstraintProblem disCP;
	private int port;
	private MultiServerThread server;
	private PropagationAlgorithm propAlg;
	private PrintStream output;
 	
 	/** Costruttore di Agent
     * 
     * @param name il nome dell'agente
     * @param problem il problema associato all'agente
     * @param addr l'IP dell'agente
     * @param p la porta dell'agente
     * @param n i vicini dell'agente
     * @param out il PrintStream su cui direzionare l'output
     * @param ma l'IP del Monitor
     * @param mp la porta del Monitor
     * 
     */	
	
	public Agent(String name,String problem,String addr,int p,Neighbourhood n,PrintStream out,String ma,int mp) 
																							throws 	ParserException,
																							LexerException,
																							ExistentVarException,
																							UnknownVariableException,
																							NotBinaryConstrException,
																							UnknownHostException
	{
		output=out;
		state= new AgentState(name,addr,p,ma,mp);
		nhood=n;
		disCP=new Parser(new Lexer(problem)).parseDisConstraintProblem();	
		port=p;
		server= new MultiServerThread(disCP,port,nhood,state,output);
		server.start();
		propAlg=new PropagationAlgorithm();
	}
	 /** Metodo run del Thread
     * 
     * 
     */	
	
	public void run()
	{

		try
		{					

		
			boolean start;
			for(int j=0;j<nhood.size();j++)
			{
				start=false;
				while(!start)
				{
					Neighbour neighApp=nhood.neighbourAt(j);
					start=sendStart(neighApp.address(),neighApp.port());
				}
			}
			
			synchronized(disCP)
			{
				propAlg.arc_consistency(disCP.localConstraintProblem());
			}
	
			output.println(state.getName()+" "+"My neighbourhood is active");
			
			for(int j=0;j<nhood.size();j++)
			{
				Neighbour neighApp=nhood.neighbourAt(j);
				String info="arc_information "; 
				Vector appName=new Vector();
				
				for(int k=0;k<neighApp.relatedVariables();k++)
				{
					for(int i=0;i<disCP.numberOfExternalConstraint();i++)
					{							
						ExtBinaryConstraint extApp=disCP.externalConstraintAt(i);
						
						if(extApp.getExternalVariable().equals(neighApp.variableAt(k) ) )
						{
							String name=extApp.getLocalVariable().getName();
							if(!appName.contains(name))
							{
								info+=name+" ";
								String dom=extApp.getLocalVariable().printDomain();
								info+=dom;
								info+=" ";								
								appName.add(name);
							}		
						}						
	
					}
				
				}
				info+=state.address();
				info+=" ";
				info+=state.port();						
				sendInformation(info,neighApp.address(),neighApp.port());
				neighApp.incrSentTo();
			}
			server.join();
		}			
		catch (NoSolutionException e)
		{
			synchronized(state)
			{
				state.setImpossible(true);
			}
			for(int j=0;j<nhood.size();j++)
			{
				Neighbour neighApp=nhood.neighbourAt(j);
				sendNoSolution(neighApp.address(),neighApp.port());
			}
			try
			{
				sendNoSolution(state.monitorAddr(),state.monitorPort());
			}
			catch(UnknownHostException he)
			{
			}
			
			output.println(state.getName()+" "+"I understood there is no solution after the first propagation.");
			lastConnection();
			
			try
			{
				server.join();
			}
			catch (InterruptedException ie)
			{
			}	
				
		}		
		catch (InterruptedException ie)
		{
		}	
		catch (Exception e)
		{
		}
	
	}
	

	private boolean sendStart(InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
						
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_start");
			socket.close();
			return true;
		}

	    catch(Exception e)
	    {
			return false;
	    }
	    	    
	}


	private void sendInformation(String message,InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println(message);
			
			output.println(state.getName()+" "+"Sent "+message);
				
			socket.close();
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
	private void sendNoSolution(InetAddress addr, int p)
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(addr, p);
						
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_no_solution");
			
				
			socket.close();			
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
	private void lastConnection()
	{
		Socket socket;
		BufferedReader in;
		PrintWriter out;
		
		try
		{
			socket = new Socket(state.address(), state.port());
			
			
			InputStreamReader isr = new InputStreamReader(socket.getInputStream());
			in = new BufferedReader(isr);
			OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream());
			out = new PrintWriter(new BufferedWriter(osw), true);
			out.println("arc_last_connection");
							
			socket.close();
		}

	    catch(Exception e)
	    {
	    }
	    	    
	}
	
}